import uuid

from django.db import models

from staff.budget_position.const import PUSH_STATUS, PositionType
from staff.budget_position.models.budget_position import BudgetPosition
from staff.budget_position.models.oebs import OEBSGrade
from staff.budget_position.models.workflow import Workflow

from staff.departments.models import Department, HRProduct, Bonus, Geography
from staff.map.models import Office, Placement
from staff.person.models import Organization, Staff
from staff.oebs import models as oebs_models


class ChangeRegistry(models.Model):
    budget_position = models.ForeignKey(BudgetPosition, null=True, related_name='changes')
    new_budget_position = models.ForeignKey(BudgetPosition, null=True, related_name='+')
    linked_budget_position = models.ForeignKey(BudgetPosition, null=True, related_name='+')
    workflow = models.ForeignKey(Workflow, null=True)

    staff_bonus_scheme = models.ForeignKey(Bonus, on_delete=models.PROTECT, null=True, verbose_name='Схема премий')
    compensation_scheme = models.ForeignKey(
        oebs_models.Reward,
        on_delete=models.PROTECT,
        null=True,
        verbose_name='Схема компенсаций',
    )
    currency = models.CharField(max_length=4, null=True, verbose_name='Валюта оклада')
    department = models.ForeignKey(Department, on_delete=models.PROTECT, null=True)
    dismissal_date = models.DateField(null=True, verbose_name='Дата увольнения')
    effective_date = models.DateField(null=True, verbose_name='Дата действия')
    geo = models.ForeignKey(Geography, on_delete=models.PROTECT, null=True, verbose_name='География')
    oebs_grade = models.ForeignKey(OEBSGrade, on_delete=models.PROTECT, null=True, verbose_name='Профессия + Грейд')
    headcount = models.IntegerField(null=True, verbose_name='Численность')
    staff_hr_product = models.ForeignKey(HRProduct, on_delete=models.PROTECT, null=True, verbose_name='HR Продукт')
    office = models.ForeignKey(Office, on_delete=models.PROTECT, null=True, verbose_name='Офис')
    organization = models.ForeignKey(Organization, on_delete=models.PROTECT, null=True, verbose_name='Организация')
    pay_system = models.ForeignKey(
        oebs_models.PaySys,
        on_delete=models.PROTECT,
        null=True,
        verbose_name='Система оплаты труда',
    )
    wage_system = models.CharField(max_length=32, null=True, verbose_name='Тип оклада')
    placement = models.ForeignKey(Placement, on_delete=models.PROTECT, null=True, verbose_name='Расположение')
    position = models.ForeignKey(oebs_models.Job, on_delete=models.PROTECT, null=True, verbose_name='Должность')
    position_name = models.CharField(max_length=60, null=True, verbose_name='Название БП')
    position_type = models.CharField(null=True, choices=PositionType.choices(), max_length=64, verbose_name='Статус')
    rate = models.DecimalField(null=True, decimal_places=3, max_digits=16, verbose_name='Ставка')
    review_scheme = models.ForeignKey(
        oebs_models.Review,
        on_delete=models.PROTECT,
        null=True,
        verbose_name='Схема ревью',
    )
    salary = models.DecimalField(null=True, decimal_places=3, max_digits=16, verbose_name='Оклад')
    staff = models.ForeignKey(Staff, on_delete=models.PROTECT, null=True, verbose_name='Человек')
    ticket = models.CharField(max_length=32, null=True, verbose_name='Тикет')
    optional_ticket = models.CharField(max_length=32, null=True, verbose_name='Еще один опциональный тикет')
    remove_budget_position = models.NullBooleanField()
    unit_manager = models.NullBooleanField()

    employment_type = models.CharField(max_length=16, null=True, verbose_name='Тип найма')
    person_id = models.IntegerField(null=True, verbose_name='ID физ. лица')
    other_payments = models.CharField(max_length=255, null=True, verbose_name='Прочие платежи')
    join_at = models.DateField(null=True, verbose_name='Дата приема')
    probation_period_code = models.IntegerField(null=True, verbose_name='Испытательный срок (код)')
    is_replacement = models.NullBooleanField(verbose_name='Является заменой')
    instead_of_login = models.CharField(max_length=50, null=True, verbose_name='Логин заменяемого')
    contract_term_date = models.DateField(null=True, verbose_name='Дата окончания контракта')
    contract_period = models.IntegerField(null=True, verbose_name='Продолжительность контракта (месяцы)')

    oebs_transaction_id = models.IntegerField(null=True)
    oebs_idempotence_key = models.UUIDField(default=uuid.uuid1)
    last_oebs_error = models.TextField(null=True)
    correction_id = models.IntegerField(null=True)
    push_status = models.CharField(choices=PUSH_STATUS, max_length=32, null=True)
    sent_to_oebs = models.DateTimeField(null=True)
    assignment_id = models.IntegerField(null=True, blank=True)

    pushed_to_femida = models.DateTimeField(null=True)

    class Meta:
        permissions = (
            ('can_export_changes', 'Can export changes'),
        )

    def __str__(self):
        return f'Change {self.id}'
