from django.db import models

from staff.person.models import Occupation


class OEBSGrade(models.Model):
    grade_id = models.IntegerField(primary_key=True)
    level = models.IntegerField(null=True, blank=True)
    occupation = models.ForeignKey(Occupation, on_delete=models.PROTECT)

    def __str__(self):
        return f'{self.occupation_id}.{self.level} {self.grade_id}'
