from django.db import models

from staff.departments.models import Bonus
from staff.lib.models.base import TrackableModel
from staff.person.models import Staff

from staff.budget_position.models.review import Review
from staff.budget_position.models.reward import Reward


class PersonSchemeExceptions(TrackableModel):
    person = models.OneToOneField(Staff, null=False)
    reward_scheme = models.ForeignKey(Reward, null=False, blank=False)
    bonus_scheme = models.ForeignKey(Bonus, null=False, blank=False)
    review_scheme = models.ForeignKey(Review, null=False, blank=False)

    def __str__(self):
        return f'{self.person.login}'
