from django.db import models

from staff.lib.models.base import TrackableModel


class Review(TrackableModel):
    scheme_id = models.IntegerField(null=False, blank=False)
    name = models.CharField(null=False, max_length=255)
    description = models.CharField(null=True, blank=True, max_length=255)
    start_date = models.DateField(null=False)
    end_date = models.DateField(null=True)
    target_bonus = models.FloatField(null=True)
    grant_type = models.CharField(null=True, blank=True, max_length=255)
    grant_type_description = models.CharField(null=True, blank=True, max_length=255)

    def __str__(self):
        return f'Id:{self.scheme_id} ({self.name})'
