from django.db import models

from staff.lib.models.base import TrackableModel
from staff.lib.utils.enum_choices import EnumChoices


class RewardCategory(EnumChoices):
    MASS_POSITIONS = 'Mass positions'
    BUSINESS_SUPPORT = 'Business support'
    PROFESSIONALS = 'Professionals'


class Reward(TrackableModel):
    scheme_id = models.IntegerField(null=False, blank=False)
    name = models.CharField(null=False, max_length=255)
    description = models.CharField(null=True, blank=True, max_length=255)
    start_date = models.DateField(null=False)
    end_date = models.DateField(null=True)
    category = models.CharField(null=True, choices=RewardCategory.choices(), max_length=32)

    def __str__(self):
        return f'Id:{self.scheme_id} ({self.name})'
