import uuid

from django.db import models

from staff.budget_position.const import WORKFLOW_STATUS
from staff.departments.models import ProposalMetadata, Vacancy
from staff.headcounts.models import CreditManagementApplication
from staff.person.models import Staff


class Workflow(models.Model):
    id = models.UUIDField(primary_key=True, null=False, default=uuid.uuid1)
    code = models.CharField(null=False, blank=False, max_length=32)

    proposal = models.ForeignKey(ProposalMetadata, on_delete=models.PROTECT, null=True)
    vacancy = models.ForeignKey(Vacancy, on_delete=models.PROTECT, null=True)
    credit_management = models.ForeignKey(CreditManagementApplication, on_delete=models.PROTECT, null=True)

    created_at = models.DateTimeField(auto_now_add=True)
    confirmed_at = models.DateTimeField(null=True)

    status = models.CharField(choices=WORKFLOW_STATUS, max_length=32, default=WORKFLOW_STATUS.PENDING)

    # Date till which catalyst is allowed to send the edit
    permission_date = models.DateField(null=True)
    # Person, responsible for the edit
    catalyst = models.ForeignKey(Staff, on_delete=models.PROTECT, null=True)
    manually_processed = models.NullBooleanField(default=None)

    def __str__(self):
        return '{} ({})'.format(self.id, self.code)
