import logging

from django.views.decorators.csrf import csrf_exempt
from django.http import JsonResponse
from django.conf import settings

import yenv
from staff.lib.decorators import consuming_json
from staff.lib.forms.errors import NO_DATA_PROVIDED, general_error

from staff.budget_position import tasks


logger = logging.getLogger(__name__)


@consuming_json
@csrf_exempt
def push_to_oebs(request, json_data):
    if json_data.get('ticket') is None:
        return JsonResponse(data=general_error(NO_DATA_PROVIDED), status=400)
    ticket = json_data.get('ticket')
    logger.error(ticket)
    if yenv.type == 'development':
        tasks.PushFromStartrekToOEBS(ticket)
    else:
        tasks.PushFromStartrekToOEBS.apply_async((ticket, ), countdown=settings.STARTREK_DELAY)
    response = {
        'ticket': ticket,
    }
    return JsonResponse(data=response, status=200)
