from django.http import HttpRequest, HttpResponse, JsonResponse

from staff.lib.decorators import auth_by_tvm_only
from staff.map.models import Placement

from staff.budget_position.forms import PlacementForm


@auth_by_tvm_only(['femida'])
def check_placement_view(request: HttpRequest) -> HttpResponse:
    form = PlacementForm(data=request.GET)

    if not form.is_valid():
        return JsonResponse(form.errors_as_dict(), status=400)

    placement_exists = (
        Placement.objects
        .filter(organization_id=form.organization_id, office_id=form.office_id, active_status=True)
        .exists()
    )

    return JsonResponse(data={'exists': placement_exists})
