from abc import ABCMeta, abstractmethod

from staff.budget_position.workflow_service.entities.abstract_workflow import AbstractWorkflow
from staff.budget_position.workflow_service.entities.budget_positions_calculator import BudgetPositionMove
from staff.budget_position.workflow_service.entities.service_dtos import FemidaData, ProposalData


class AbstractFemidaWorkflowFactory(metaclass=ABCMeta):
    @abstractmethod
    def create(self, data: FemidaData) -> AbstractWorkflow:
        pass


class AbstractProposalWorkflowFactory(metaclass=ABCMeta):
    @abstractmethod
    def create_workflow(self, data: ProposalData, budget_position: BudgetPositionMove) -> AbstractWorkflow:
        pass
