import attr

from staff.budget_position.workflow_service.entities.attributes.validators import (
    optional_int,
    optional_string,
)
from staff.budget_position.workflow_service.entities.types import (
    BonusSchemeId,
    OccupationId,
    ReviewSchemeId,
    RewardSchemeId,
)


grade_id: int = attr.ib(default=None, validator=optional_int)
grade_level: int = attr.ib(default=None, validator=optional_int)
grade_change: str = attr.ib(default=None, validator=optional_string)

review_scheme_id: ReviewSchemeId = attr.ib(default=None, validator=optional_int)
bonus_scheme_id: BonusSchemeId = attr.ib(default=None, validator=optional_int)
reward_scheme_id: RewardSchemeId = attr.ib(default=None, validator=optional_int)
force_recalculate_schemes: bool = attr.ib(default=False)

occupation_id: OccupationId = attr.ib(default=None, validator=optional_string)
