from decimal import Decimal

import attr

from staff.budget_position.workflow_service.entities.attributes.validators import optional_string


def optional_decimal(instance, attribute, value):
    if value is None:
        return

    if not isinstance(value, Decimal):
        raise ValueError('{} must be Decimal (got {})'.format(attribute.name, type(value)))


payment_system: str = attr.ib(default=None, validator=optional_string)
wage_system: str = attr.ib(default=None, validator=optional_string)
currency: str = attr.ib(default=None, validator=optional_string)
salary: str = attr.ib(default=None, validator=optional_string)
rate: Decimal = attr.ib(default=None, validator=optional_decimal)
other_payments: str = attr.ib(default=None, validator=optional_string)
