from datetime import date


def optional_string(instance, attribute, value):
    if value is None:
        return

    if not isinstance(value, str):
        raise ValueError('{} must be string (got {})'.format(attribute.name, type(value)))


def optional_date(instance, attribute, value):
    if value is None:
        return

    if not isinstance(value, date):
        raise ValueError('{} must be date or NoneType (got {})'.format(attribute.name, type(value)))


def optional_int(instance, attribute, value):
    if value is None:
        return

    if not isinstance(value, int):
        raise ValueError('{} must be int or long (got {})'.format(attribute.name, type(value)))
