from abc import ABCMeta
from typing import Any, List, Set

from staff.budget_position.workflow_service.entities.types import BudgetPositionCode


class ConflictWorkflowExistsError(Exception):
    def __init__(self, conflicting_workflows: List['AbstractWorkflow'], *args: Any):
        super().__init__(*args)
        self.conflicting_workflows = conflicting_workflows


class InvalidVacanciesIds(Exception):
    def __init__(self, vacancies_ids: Set[int], *args: Any):
        super().__init__(*args)
        self.invalid_vacancies_ids = vacancies_ids


class AbstractWorkflowResolveError(Exception, metaclass=ABCMeta):
    pass


class UnknownBP(AbstractWorkflowResolveError):
    pass


class UnknownAssignment(AbstractWorkflowResolveError):
    pass


class UnknownHrProduct(AbstractWorkflowResolveError):
    pass


class NoHRAnalyst(AbstractWorkflowResolveError):
    pass


class EmptyBPOnNonVacancyCreation(AbstractWorkflowResolveError):
    pass


class BPStateRelatedWorkflowResolveError(AbstractWorkflowResolveError, metaclass=ABCMeta):
    def __init__(self, budget_position_code: BudgetPositionCode, *args: object) -> None:
        super().__init__(*args)
        self.budget_position_code = budget_position_code


class NonOfferRejectionForOfferBp(BPStateRelatedWorkflowResolveError):
    pass


class NonVacancyCreationForPlanBP(BPStateRelatedWorkflowResolveError):
    pass


class NonVacancyCreationForOccupiedBP(BPStateRelatedWorkflowResolveError):
    pass


class NotSupportedBPState(BPStateRelatedWorkflowResolveError):
    pass
