from abc import ABCMeta, abstractmethod
from typing import Dict, List, Optional, Set

from staff.budget_position.workflow_service.entities.budget_positon import BudgetPosition
from staff.budget_position.workflow_service.entities.types import BudgetPositionCode


class BudgetPositionsRepository(metaclass=ABCMeta):
    @abstractmethod
    def budget_position_by_code(self, code: BudgetPositionCode) -> BudgetPosition:
        pass

    @abstractmethod
    def budget_position_by_code_or_none(self, code: BudgetPositionCode) -> Optional[BudgetPosition]:
        pass

    @abstractmethod
    def budget_position_by_id(self, bp_id: BudgetPositionCode) -> Optional[BudgetPosition]:
        pass

    @abstractmethod
    def budget_positions_by_codes(self, codes: List[BudgetPositionCode]) -> List[BudgetPosition]:
        pass

    @abstractmethod
    def assignments_statuses_by_codes(self, codes: List[BudgetPositionCode]) -> Set[str]:
        pass

    @abstractmethod
    def get_or_create_new(self, code: BudgetPositionCode) -> BudgetPosition:
        pass

    @abstractmethod
    def headcount_position_data_by_vacancy_ids(self, vacancy_ids: List[int]) -> Dict[int, BudgetPosition]:
        pass

    @abstractmethod
    def headcount_position_data_by_persons_ids(self, person_ids: List[int]) -> Dict[int, Optional[BudgetPosition]]:
        pass
