from abc import ABCMeta, abstractmethod
from typing import Dict, List
from uuid import UUID


class FemidaService(metaclass=ABCMeta):
    @abstractmethod
    def schedule_department_push(self, workflow_id: UUID):
        pass

    @abstractmethod
    def change_vacancy_url(self, vacancy_id: int):
        pass

    @abstractmethod
    def close_vacancy_url(self, vacancy_id: int):
        pass

    @abstractmethod
    def close_vacancy(self, workflow_id: UUID):
        pass

    @abstractmethod
    def push_scheduled(self):
        pass

    @abstractmethod
    def vacancies_by_job_ticket_urls(self, job_ticket_urls: List[str]) -> Dict[str, int]:
        pass
