from abc import ABCMeta, abstractmethod
from typing import List

import attr

from staff.budget_position.workflow_service.entities.types import (
    BonusSchemeId,
    OccupationId,
    ReviewSchemeId,
    RewardCategory,
    RewardSchemeId,
)


@attr.s(auto_attribs=True, frozen=True)
class ReviewSchemeIdRequest:
    occupation_id: OccupationId
    department_id: int
    grade_level: int or None


@attr.s(auto_attribs=True, frozen=True)
class ReviewSchemeIdByGroupRequest:
    occupation_review_group: str
    department_id: int
    grade_level: int or None


@attr.s(auto_attribs=True, frozen=True)
class BonusSchemeIdRequest:
    department_id: int
    occupation_id: OccupationId
    grade_level: int or None


@attr.s(auto_attribs=True, frozen=True)
class BonusSchemeIdByGroupRequest:
    occupation_bonus_group: str
    department_id: int
    grade_level: int or None


@attr.s(auto_attribs=True, frozen=True)
class RewardCategoryRequest:
    occupation_reward_group: str
    grade_level: int or None


@attr.s(auto_attribs=True, frozen=True)
class RewardSchemeIdRequest:
    department_id: int
    category: RewardCategory
    is_internship: bool


class TableflowService(metaclass=ABCMeta):
    @abstractmethod
    def review_scheme_id(self, requests: List[ReviewSchemeIdRequest]) -> List[ReviewSchemeId or None]:
        pass

    @abstractmethod
    def review_scheme_id_by_group(self, requests: List[ReviewSchemeIdByGroupRequest]) -> List[ReviewSchemeId or None]:
        pass

    @abstractmethod
    def bonus_scheme_id(self, requests: List[BonusSchemeIdRequest]) -> List[BonusSchemeId or None]:
        pass

    @abstractmethod
    def bonus_scheme_id_by_group(self, requests: List[BonusSchemeIdByGroupRequest]) -> List[BonusSchemeId or None]:
        pass

    @abstractmethod
    def reward_category(self, requests: List[RewardCategoryRequest]) -> List[RewardCategory or None]:
        pass

    @abstractmethod
    def reward_scheme_id(self, requests: List[RewardSchemeIdRequest]) -> List[RewardSchemeId or None]:
        pass
