import calendar
from datetime import date
from dateutil.relativedelta import relativedelta


class DateProvider:
    @staticmethod
    def today() -> date:
        return date.today()

    @staticmethod
    def get_month_last_day(current: date) -> int:
        return calendar.monthrange(current.year, current.month)[1]

    @staticmethod
    def add(current: date, days: int = 0, months: int = 0) -> date:
        return current + relativedelta(days=days, months=months)
