import logging
from typing import Optional

from staff.budget_position.workflow_service.entities import Change
from staff.budget_position.workflow_service.entities.abstract_workflow import AbstractWorkflow


logger = logging.getLogger(__name__)


class Workflow7_1(AbstractWorkflow):
    code = '7.1'
    description = 'Proposal changes without maternity and with budget'
    fields_not_changing_budget_position = {
        'id',
        'workflow_id',
        'budget_position',
        'effective_date',
        'person_id',
        'ticket',
        'oebs_idempotence_key',
    }

    @property
    def should_be_pushed_automatically(self):
        return self._changes_only_position()

    @property
    def should_be_marked_manually_processed_automatically(self):
        return self._changes_only_position()

    def _changes_only_position(self):
        if len(self.changes) != 1:
            return False

        fields_with_values = self.changes[0].fields_with_values()
        fields_changing_position = fields_with_values - self.fields_not_changing_budget_position
        return fields_changing_position == {'position_id', }


class Workflow1_1_1(AbstractWorkflow):
    code = '1.1.1'
    description = 'Proposal changes to vacancy department'
    should_push_new_department_to_femida = True

    def get_next_change_for_sending(self) -> Optional[Change]:
        result = super().get_next_change_for_sending()
        return result if result and result.budget_position else None


class HeadcountChangeFromProposalWorkflow(AbstractWorkflow):
    code = '7.2'
    description = 'Proposal changes to headcounts department'


class Workflow7_100500(AbstractWorkflow):
    code = '7.100500'
    description = 'Stub workflow for all proposal changes. Should be last in the list'
    should_be_pushed_automatically = True
    should_be_marked_manually_processed_automatically = True


class MoveWithoutBudgetPositionWorkflow(AbstractWorkflow):
    code = '7.3'
    description = 'Move person to other budget position'
