from typing import Tuple

from staff.departments.models import Geography


class GeographyResolver:
    @staticmethod
    def resolve_geography(geography_url: str or None) -> Tuple[int or None, str or None]:
        if geography_url is None:
            return None, None

        geography = (
            Geography.objects
            .prefetch_related('department_instance')
            .get(department_instance__url=geography_url)
        )
        geography_description = f'{geography.name} ({geography.oebs_code})'

        if not geography.intranet_status:
            return None, f'Geography {geography_description} is disabled'

        if not geography.department_instance.intranet_status:
            department_description = f'{geography.department_instance.name} ({geography.department_instance.url})'
            return None, f'Department {department_description} linked to Geography {geography_description} is disabled'

        return geography.department_instance_id, None
