from typing import Tuple

from staff.departments.models import HRProduct


class HRProductResolver:
    @staticmethod
    def resolve_hr_product(hr_product_id: int or None) -> Tuple[int or None, str or None]:
        if hr_product_id is None:
            return None, None

        hr_product = HRProduct.objects.prefetch_related('value_stream').get(id=hr_product_id)
        hr_product_description = f'{hr_product.product_name} ({hr_product_id})'

        if not hr_product.intranet_status:
            return None, f'HR Product {hr_product_description} is disabled'

        if hr_product.value_stream_id is None:
            return None, f'No VS linked to HR Product {hr_product_description}'

        if not hr_product.value_stream.intranet_status:
            value_stream_description = f'{hr_product.product_name} ({hr_product.value_stream.url})'
            return None, f'VS {value_stream_description} linked to HR Product {hr_product_description} is disabled'

        return hr_product.value_stream_id, None
