from staff.lib.tasks import add_comment_task, create_issue_task, update_issue_task

from staff.budget_position.workflow_service import use_cases


class StartrekService(use_cases.StartrekService):
    def create_issue(self, **fields) -> None:
        create_issue_task.delay(**fields)

    def update_issue(self, key: str, **fields) -> None:
        update_issue_task.delay(key, **fields)

    def add_comment(self, key: str, text: str, **fields) -> None:
        add_comment_task.delay(key, text, **fields)
