from uuid import UUID
import logging
from typing import Optional

from staff.budget_position.workflow_service import entities
from staff.budget_position.workflow_service.use_cases.interfaces import CreditManagementServiceInterface


logger = logging.getLogger(__name__)


class Cancel:
    def __init__(
        self,
        repository: entities.WorkflowRepositoryInterface,
        credit_management_service: CreditManagementServiceInterface,
    ):
        self._repository = repository
        self._credit_management_service = credit_management_service

    def cancel(self, workflow_id: UUID, person_id: Optional[int]) -> None:
        workflow = self._repository.get_by_id(workflow_id)
        workflow.cancel(person_id)
        self._repository.save(workflow)
        logger.info('Marked workflow as cancelled')

        if workflow.credit_management_id:
            self._credit_management_service.notify_about_changes_for_application(
                workflow.credit_management_id,
                person_id,
            )

    def cancel_workflows_for_credit_repayment(self, credit_management_application_id: int) -> None:
        # we do not notify credit management service here, as it is single only source of cancelling
        self._repository.cancel_workflows_for_credit_repayment(credit_management_application_id)
