from uuid import UUID

from staff.budget_position.workflow_service import entities


class GetOEBSLink:
    def __init__(self, oebs_service: entities.OEBSService, workflow_repository: entities.WorkflowRepositoryInterface):
        self._oebs_service = oebs_service
        self._workflow_repository = workflow_repository

    def position_link(self, workflow_id: UUID, change_id: int, login: str, for_write: bool) -> str:
        assert workflow_id is not None
        assert change_id is not None
        assert login is not None
        assert for_write is not None

        workflow = self._workflow_repository.get_by_id(workflow_id)
        change = self._get_change_from_workflow_by_id(workflow, change_id)
        result = self._oebs_service.get_position_link(change, login, for_write)
        return result

    def budget_link(self, workflow_id: UUID, change_id: int):
        assert workflow_id is not None
        assert change_id is not None

        workflow = self._workflow_repository.get_by_id(workflow_id)
        change = self._get_change_from_workflow_by_id(workflow, change_id)
        result = self._oebs_service.get_budget_link(change)
        return result

    def _get_change_from_workflow_by_id(self, workflow: entities.AbstractWorkflow, change_id: int) -> entities.Change:
        for change in workflow.changes:
            if change.id == change_id:
                return change

        raise StopIteration
