from abc import ABCMeta, abstractmethod
from typing import Optional

from staff.budget_position.workflow_service.entities import AbstractWorkflow, Change


class OebsHireService(metaclass=ABCMeta):
    """
    Сервис Я.Найм, сервис-обертка над связанным с наймом функционалом oebs
    """
    @abstractmethod
    def push_workflow(self, workflow: AbstractWorkflow) -> None:
        pass

    @abstractmethod
    def send_change(self, change: Change) -> None:
        pass


class StartrekService(metaclass=ABCMeta):
    @abstractmethod
    def create_issue(self, **fields) -> None:
        pass

    @abstractmethod
    def update_issue(self, key: str, **fields) -> None:
        pass

    @abstractmethod
    def add_comment(self, key: str, text: str, **fields) -> None:
        pass


class CreditManagementServiceInterface(metaclass=ABCMeta):
    @abstractmethod
    def notify_about_changes_for_application(
        self,
        credit_management_application_id: int,
        person_id: Optional[int],
    ) -> None:
        pass
