from staff.person.models import DOMAIN


class NativeCardBuilder(object):

    def name(self, data):
        return '%s %s' % (data['first_name'], data['last_name'])

    def fullname(self, data):
        return ' '.join(self.name(data)).strip()

    def position(self, data):
        return data['position']

    def office(self, data):
        return data['office'] and '%s\n%s' % (data['office'].address1, data['office'].address2)

    def phone(self, data):
        phone_no = getattr(data['office'], 'phone', '').strip()
        if not phone_no:
            return ''
        r = 'тел.: %s' % phone_no
        if data['work_phone']:
            r += ', доб.: %s' % data['work_phone']

        return r

    def fax(self, data):
        fax_no = data['office'].fax
        if not fax_no.strip() or data['show_fax'] == 'false':
            return ''
        return 'факс: %s' % fax_no

    def site(self, data):
        try:
            return data['office'].city.country.yandex_domain
        except AttributeError:
            return 'yandex.ru'

    def email(self, data):
        return '%s@%s' % (data['email_login'], DOMAIN[data['email_domain']])

    def mobile(self, data):
        return data['mobile_phone'] and 'моб.: %s' % data['mobile_phone']

    def other(self, data):
        return data['other'] or ' '

    def lang(self, data):
        return 'native'

    def extra_phone(self, data):
        return 'тел.: %s' % data['extra_phone'] if data['extra_phone'] else ''


class EnglishCardBuilder(NativeCardBuilder):

    def office(self, data):
        return data['office'] and '%s\n%s' % (data['office'].address1_en, data['office'].address2_en)

    def phone(self, data):
        phone_no = getattr(data['office'], 'phone', '').strip()
        if not phone_no:
            return ''
        r = 'tel.: %s' % phone_no
        if data['work_phone']:
            r += ', ext.: %s' % data['work_phone']

        return r

    def fax(self, data):
        fax_no = data['office'].fax
        if not fax_no.strip() or data['show_fax'] == 'false':
            return ''
        return 'fax: %s' % fax_no

    def site(self, data):
        return 'yandex.com'

    def mobile(self, data):
        return data['mobile_phone'] and 'cell: %s' % data['mobile_phone']

    def lang(self, data):
        return 'en'

    def extra_phone(self, data):
        return 'tel.: %s' % data['extra_phone'] if data['extra_phone'] else ''
