from staff.map.models import Office

from staff.person.models import DOMAIN

from staff.lib.forms.staff_form import StaffForm
from staff.lib.forms.staff_fields import (
    StaffCharField,
    StaffLocalizedModelChoiceField,
    StaffChoiceField,
    StaffBooleanField,
    StaffFileField,
)

from staff.lib.utils.ordered_choices import OrderedChoices

YES_NO = OrderedChoices(
    ('YES', "true", 'Да'),
    ('NO', "false", 'Нет'),
)


class OrderCardForm(StaffForm):
    last_name = StaffCharField(max_length=50, required=False)
    first_name = StaffCharField(max_length=50, required=False)
    position = StaffCharField(max_length=150, required=False)
    office = StaffLocalizedModelChoiceField(
        empty_label=None,
        queryset=Office.objects.filter(intranet_status=1)
    )
    email_login = StaffCharField(max_length=50, required=False)
    email_domain = StaffChoiceField(choices=DOMAIN.choices(), required=True)
    work_phone = StaffCharField(required=False, max_length=100)
    mobile_phone = StaffCharField(max_length=50, required=False)
    extra_phone = StaffCharField(max_length=50, required=False)
    show_fax = StaffChoiceField(choices=YES_NO)
    other = StaffCharField(max_length=50, required=False)


class EnglishPositionFormMixin(object):

    def clean_position(self):
        pos = self.cleaned_data['position']
        return capitalize_english_position(pos)


class OrderCardEnForm(OrderCardForm, EnglishPositionFormMixin):
    pass


class OrderCardBackForm(StaffForm, EnglishPositionFormMixin):
    last_name = StaffCharField(max_length=50, required=False)
    first_name = StaffCharField(max_length=50, required=False)
    position = StaffCharField(max_length=150, required=False)


class OrderCardUploadForm(StaffForm):
    office = StaffLocalizedModelChoiceField(
        empty_label=None,
        queryset=Office.objects.filter(intranet_status=1)
    )
    is_single = StaffBooleanField(required=False)
    pdf = StaffFileField()


def smart_capitalize(position):
    parts = position.split()
    prepositions = ('at', 'of', 'in', 'to', 'on', 'by', 'with', 'the', 'and',
                    'or', 'a')
    newparts = []
    for idx, part in enumerate(parts):
        first_part = (idx == 0)
        if len(part) > 1 and part == part.upper():  # abbreviation
            newparts.append(part)
        elif part.lower() in prepositions and not first_part:
            newparts.append(part.lower())
        elif part.startswith("!"):
            newparts.append(part[1:])
        elif part == part.lower():
            # If you include some capital letters, in your word,
            # you probably know what you're doing
            newparts.append(part.capitalize())
        else:
            newparts.append(part)
    return " ".join(newparts)


def capitalize_english_position(pos):
    # Capitalize position name, http://st.yandex-team.ru/STAFF-1773
    # Like this: "master of puppets" => "Master of Puppets"
    lines = pos.split('\n')
    return '\n'.join([smart_capitalize(line) for line in lines])
