from django.conf.urls import url

from rest_framework.urlpatterns import format_suffix_patterns

from staff.celery_tools import views


urlpatterns = [
    url(
        r'^$',
        views.TaskListView.as_view(),
        name='list_tasks'
    ),

    url(
        r'^running/?$',
        views.RunningTaskListView.as_view(),
        name='list_running_tasks'
    ),

    url(
        r'^finished/?$',
        views.FinishedTaskListView.as_view(),
        name='list_finished_tasks'
    ),

    url(
        r'^running/(?P<task_id>[\w-]{36})/?$',
        views.RunningTaskDetailsView.as_view(),
        name='task_details'
    ),
]

urlpatterns = format_suffix_patterns(urlpatterns)
