import attr


@attr.s(auto_attribs=True)
class HeadcountAction(object):
    headcount_code: int
    department: str or None = None
    fake_department: str or None = None
    action_id: str or None = None
    dep_chain: str or None = None
    value_stream: str or None = None
    geography: str or None = None
    force_recalculate_schemes: bool = False

    @staticmethod
    def _as_dict_filter_none(obj, recurse=True):
        return attr.asdict(obj, filter=lambda _, value: value is not None, recurse=recurse)

    @classmethod
    def from_dict(cls, headcount_actions):
        simple_fields = ('headcount_code', 'action_id', 'value_stream', 'geography')
        return cls(
            department=headcount_actions.get('department') or {},
            fake_department=headcount_actions.get('fake_department') or {},
            dep_chain=headcount_actions.get('__department_chain__'),
            **{f: headcount_actions.get(f) for f in simple_fields}
        )

    def copy_with_meta(self, **kwargs):
        return HeadcountAction(
            headcount_code=self.headcount_code,
            dep_chain=self.dep_chain,
            value_stream=self.value_stream,
            geography=self.geography,
            **kwargs,
        )

    def as_dict(self):
        res = self._as_dict_filter_none(self, recurse=False)
        dep_chain = res.pop('dep_chain', None)

        if dep_chain is not None:
            res['__department_chain__'] = dep_chain

        res['department'] = self.department or ''
        res['fake_department'] = self.fake_department or ''

        return res
