import attr
from typing import List, Any, Dict

from staff.departments.controllers.actions.department_action import DepartmentAction
from staff.departments.controllers.actions.headcount_action import HeadcountAction
from staff.departments.controllers.actions.person_action import PersonAction
from staff.departments.controllers.actions.vacancy_action import VacancyAction


@attr.s(auto_attribs=True)
class ProposalActions:
    person_actions: List[PersonAction]
    department_actions: List[DepartmentAction]
    vacancy_actions: List[VacancyAction]
    headcount_actions: List[HeadcountAction]

    @classmethod
    def from_proposal_obj(cls, obj: Dict[str, Any]):
        return cls(
            department_actions=list(map(DepartmentAction.from_dict, obj['actions'])),
            person_actions=list(map(PersonAction.from_dict, obj['persons']['actions'])),
            vacancy_actions=list(map(VacancyAction.from_dict, obj['vacancies']['actions'])),
            headcount_actions=list(map(HeadcountAction.from_dict, obj['headcounts']['actions'])),
        )

    def as_dict(self):
        fields = [
            'department_actions',
            'person_actions',
            'vacancy_actions',
            'headcount_actions',
        ]
        res = {}
        for f in fields:
            res[f] = [it.as_dict() for it in getattr(self, f)]
        return res
