import logging

logger = logging.getLogger('staff.department.exceptions')


class DepartmentException(Exception):
    def __init__(self, message, code=None, params=None):
        self.message = message
        self.code = code or ''
        self.params = params or {}
        logger.exception(
            'Error while edit departments\n message: %s, code: %s, params: %s', self.message, self.code, self.params,
        )


class ProposalCtlError(DepartmentException):
    pass


class DepartmentCtlError(DepartmentException):
    pass


class KindException(Exception):
    pass


class KindNotFound(KindException):
    pass


class BpConflict(Exception):
    def __init__(self, meta):
        self.meta = meta
