class DepartmentGroupCtl(object):
    CTL_FIELDS = ['parent_id']

    def __init__(self, group_instance):
        self.instance = group_instance

    def __getattr__(self, name):
        try:
            return super(DepartmentGroupCtl, self).__getattr__(name)
        except AttributeError:
            if name in self.CTL_FIELDS:
                raise
            return getattr(self.instance, name)

    def __setattr__(self, name, value):
        is_group_attr = (
            name not in ['instance', '_author'] and
            hasattr(self.instance, name) and
            name not in self.CTL_FIELDS
        )

        if is_group_attr:
            setattr(self.instance, name, value)
        else:
            super(DepartmentGroupCtl, self).__setattr__(name, value)

    def save(self, *args, **kwargs):
        self.instance.save(*args, **kwargs)
        descendants = (
            self.instance
            .get_descendants()
            .filter(intranet_status=1)
            .order_by('level')
        )
        for subgroup in descendants:
            subgroup.save()
