import logging
from collections import abc
from staff.departments.models import DepartmentKind

logger = logging.getLogger(__name__)


class InstanceGetter(object):
    def __init__(self, quesyset, lookup_unique_field: str):
        self.cache = {}
        self.queryset = quesyset
        self.lookup_unique_field = lookup_unique_field

    def __call__(self, *args, **kwargs):
        lookup_value = args[0] if args else kwargs.get(self.lookup_unique_field)

        if not lookup_value:
            return None
        if isinstance(lookup_value, abc.Iterable) and not isinstance(lookup_value, str):
            if set(lookup_value) - set(self.cache.keys()):
                all_instances = list(self.queryset.filter(
                    **{self.lookup_unique_field+'__in': lookup_value}
                ))
                for instance in all_instances:
                    self.cache[getattr(instance, self.lookup_unique_field)] = instance

                return all_instances
            else:
                return [self.cache[field_value] for field_value in lookup_value]

        if lookup_value not in self.cache:
            try:
                self.cache[lookup_value] = self.queryset.get(**{self.lookup_unique_field: lookup_value})
            except Exception as exc:
                logger.warning(
                    'Error trying to get instance with `%s == %s`: %s',
                    self.lookup_unique_field,
                    lookup_value,
                    str(exc),
                )
                return None
        return self.cache[lookup_value]


get_kind = InstanceGetter(DepartmentKind.objects, 'id')
