from staff.departments.controllers.actions.person_action import PersonAction
from staff.departments.models import HeadcountPosition, Vacancy
from staff.femida.utils import FemidaUtils
from staff.person.models import Staff


class InternTransferDetector:
    def __init__(self, femida_utils: FemidaUtils = None) -> None:
        self._femida_utils = femida_utils or FemidaUtils()

    def is_intern_transfer_to_staff(self, person_action) -> bool:
        """
        Сотрудника с признаком "Стажер" переводят без бюджета на БП с численностью = 1.
        Прямого признака стажера в стафе нет. Он есть на текущей БП сотрудника, его схема компенсаций = Intern.
        Пока определяем как date_completion_internship is None, при исполнении пропозала за признаком нужно следить.
        """
        if isinstance(person_action, dict):
            person_action: PersonAction = PersonAction.from_dict(person_action)

        if not person_action.has_dep_change() or person_action.department.with_budget:
            return False

        if Staff.objects.get(login=person_action.login).date_completion_internship is None:
            return False

        ticket = self._femida_utils.get_vacancy_issue_key_from_url(person_action.department.vacancy_url)
        position_code = Vacancy.objects.get(ticket=ticket).headcount_position_code

        headcount_position = HeadcountPosition.objects.filter(code=position_code).first()
        return headcount_position is not None and headcount_position.headcount == 1
