from staff.femida.utils import FemidaUtils
from staff.departments.models import HeadcountPosition, Vacancy


class PersonActionValidator:
    def __init__(self, femida_utils: FemidaUtils = None) -> None:
        self._femida_utils = femida_utils or FemidaUtils()

    def validate(self, person_action):
        if 'department' not in person_action:
            return

        department_section = person_action['department']

        if department_section.get('with_budget'):
            return

        vacancy_url = department_section.get('vacancy_url')
        key = self._femida_utils.get_vacancy_issue_key_from_url(vacancy_url)

        if not key:
            raise PersonActionValidationError('cannot_find_vacancy_key')

        vacancies = Vacancy.objects.filter(ticket=key).all()

        if len(vacancies) == 0:
            raise PersonActionValidationError('no_vacancies')

        if len(vacancies) > 1:
            raise PersonActionValidationError('multiple_vacancies')

        vacancy = vacancies[0]

        if not vacancy.budget_position_id:
            raise PersonActionValidationError('vacancy_without_budget_position')

        if HeadcountPosition.objects.filter(code=vacancy.headcount_position_code).first() is None:
            raise PersonActionValidationError('no_headcount_position')


class PersonActionValidationError(Exception):
    code = 'person_action_validation_error'
    message = 'person_action_validation_error'
    field = '[department][vacancy_url]'
    params = {}

    def __init__(self, code: str, params=None, *args: object) -> None:
        super().__init__(*args)
        self.code = f'person_action_{code}_error'
        self.params = params
