from django.conf import settings

from staff.proposal.models import CityAttrs


class CityAttrsCtl:

    def __init__(self):
        self._attrs = None

    def __call__(self, person, new_office=None):
        city_id = city_id_from_person(person, new_office)

        hr_login = self.attrs.get(city_id, {}).get('hr')
        if hr_login is None or hr_login == person.login:
            hr_login = self.attrs[None]['hr']

        name = self.attrs.get(city_id, {}).get('name')
        if not name:
            name = 'Надомник'

        return {'hr': hr_login, 'name': name}

    @property
    def attrs(self):
        if self._attrs is None:
            attrs = (
                CityAttrs.objects
                .values('city_id', 'city__name', 'hr__login')
            )
            self._attrs = {
                ca['city_id']: {
                    'hr': ca['hr__login'],
                    'name': ca['city__name']
                }
                for ca in attrs
            }
        return self._attrs


def city_id_from_person(person, new_office=None):
    office = new_office or person.office
    if not office or office.id == settings.HOMIE_OFFICE_ID or not office.city:
        return None
    return office.city.id
