from typing import Dict
import logging

from staff.oebs.models import (
    Employee,
    Job,
)

logger = logging.getLogger(__name__)


def get_official_positions(person_ids) -> Dict[int, str]:
    return dict(
        Employee.objects
        .values_list('dis_staff_id', 'job_name')
        .filter(dis_staff__in=person_ids)
    )


def get_official_position(person_id: int) -> str:
    return get_official_positions([person_id]).get(person_id, '')


def get_new_official_position(job_code_or_value):
    name_position = None
    try:
        if isinstance(job_code_or_value, int):
            job = Job.objects.get(code=job_code_or_value)
            name_position = '%s' % (job.name or job.name_en)
    except Exception as e:
        logger.warning('Failed search Job with code=%s, (%s)' % (job_code_or_value, e))
    if not name_position:
        name_position = job_code_or_value
    return name_position
