from datetime import date, datetime, timedelta
from django.utils.functional import SimpleLazyObject
from staff.departments.models import Department

LAST_POSSIBLE_DAY = 12  # после 12-го числа не даём выбирать первый рабочий день текущего месяца.


def nearest_hr_dates(today=None):
    today = today or date.today()
    today_day = today.day
    if today_day > LAST_POSSIBLE_DAY:
        today = today + timedelta(days=20)  # Чтобы точно месяц сменить

    for num, val in enumerate(HR_DATES):
        hr_date = datetime.strptime(val[0], '%Y-%m-%d').date()
        if today < hr_date:
            return HR_DATES[num-1:][:6]
    return HR_DATES


# Первый рабочий день месяца на несколько лет вперёд
HR_DATES = (
    ('2016-11-01', '1 нобяря 2016'),
    ('2016-12-01', '1 декабря 2016'),
    # 2017
    ('2017-01-09', '9 января 2017'),
    ('2017-02-01', '1 февраля 2017'),
    ('2017-03-01', '1 марта 2017'),
    ('2017-04-03', '3 апреля 2017'),
    ('2017-05-02', '2 мая 2017'),
    ('2017-06-01', '1 июня 2017'),
    ('2017-07-03', '3 июля 2017'),
    ('2017-08-01', '1 августа 2017'),
    ('2017-09-01', '1 сентября 2017'),
    ('2017-10-02', '2 октября 2017'),
    ('2017-11-01', '1 ноября 2017'),
    ('2017-12-01', '1 декабря 2017'),
    # 2018
    ('2018-01-09', '9 января 2018'),
    ('2018-02-01', '1 февраля 2018'),
    ('2018-03-01', '1 марта 2018'),
    ('2018-04-02', '2 апреля 2018'),
    ('2018-05-02', '2 мая 2018'),
    ('2018-06-01', '1 июня 2018'),
    ('2018-07-02', '2 июля 2018'),
    ('2018-08-01', '1 августа 2018'),
    ('2018-09-03', '3 сентября 2018'),
    ('2018-10-01', '1 октября 2018'),
    ('2018-11-01', '1 ноября 2018'),
    ('2018-12-03', '3 декабря 2018'),
    # 2019
    ('2019-01-09', '9 января 2019'),
    ('2019-02-01', '1 февраля 2019'),
    ('2019-03-01', '1 марта 2019'),
    ('2019-04-01', '1 апреля 2019'),
    ('2019-05-02', '2 мая 2019'),
    ('2019-06-03', '3 июня 2019'),
    ('2019-07-01', '1 июля 2019'),
    ('2019-08-01', '1 августа 2019'),
    ('2019-09-02', '2 сентября 2019'),
    ('2019-10-01', '1 октября 2019'),
    ('2019-11-01', '1 ноября 2019'),
    ('2019-12-02', '2 декабря 2019'),
    # 2020
    ('2020-01-09', '9 января 2020'),
    ('2020-02-03', '3 февраля 2020'),
    ('2020-03-02', '2 марта 2020'),
    ('2020-04-01', '1 апреля 2020'),
    ('2020-05-04', '4 мая 2020'),
    ('2020-06-01', '1 июня 2020'),
    ('2020-07-01', '1 июля 2020'),
    ('2020-08-03', '3 августа 2020'),
    ('2020-09-01', '1 сентября 2020'),
    ('2020-10-01', '1 октября 2020'),
    ('2020-11-02', '2 ноября 2020'),
    ('2020-12-01', '1 декабря 2020'),
    # 2021
    ('2021-01-11', '11 января 2021'),
    ('2021-02-01', '1 февраля 2021'),
    ('2021-03-01', '1 марта 2021'),
    ('2021-04-01', '1 апреля 2021'),
    ('2021-05-03', '3 мая 2021'),
    ('2021-06-01', '1 июня 2021'),
    ('2021-07-01', '1 июля 2021'),
    ('2021-08-02', '2 августа 2021'),
    ('2021-09-01', '1 сентября 2021'),
    ('2021-10-01', '1 октября 2021'),
    ('2021-11-01', '1 ноября 2021'),
    ('2021-12-01', '1 декабря 2021'),
    # 2022
    ('2022-01-10', '10 января 2022'),
    ('2022-02-01', 'НАПИШИТЕ НА TOOLS добавить месяцев'),
    ('2022-03-01', '1 марта 2022'),
    ('2022-04-01', '1 апрель 2022'),
)

# Урл: tree_id корневых подразделений, изменения в которых должны сопровождаться тикетами.
HR_CONTROLLED_DEPARTMENT_ROOTS = SimpleLazyObject(
    lambda: Department.get_tree_ids(['yandex', 'outstaff'])
)
