# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.contrib.postgres.fields


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Bonus',
            fields=[
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('scheme_id', models.IntegerField(primary_key=True, serialize=False)),
                ('schemes_line_id', models.IntegerField(null=True)),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(max_length=255, blank=True, null=True)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(null=True)),
                ('scheme_data', models.TextField(max_length=10240, blank=True, null=True)),
                ('non_review_bonus', models.FloatField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DepartmentChain',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('chiefs', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), size=None)),
                ('hr_partners', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), size=None)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
