# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import staff.departments.models.hr_deadline


class Migration(migrations.Migration):

    dependencies = [
        ('person', '0001_initial'),
        ('departments', '0001_initial'),
        ('budget_position', '0002_auto_20211007_1807'),
        ('auth', '0006_require_contenttypes_0002'),
        ('preprofile', '0001_initial'),
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='DepartmentHeadcount',
            fields=[
                ('department', models.OneToOneField(primary_key=True, serialize=False, related_name='headcount', to='django_intranet_stuff.Department')),
                ('total_headcount', models.IntegerField(verbose_name='Потолок')),
                ('occupied_new_headcount', models.IntegerField(verbose_name='Численность работающих сотрудников', default=0)),
                ('offer_new_headcount', models.IntegerField(verbose_name='Офферы', default=0)),
                ('vacancy_open_new_headcount', models.IntegerField(verbose_name='Открытые вакансии', default=0)),
                ('vacancy_plan_new_headcount', models.IntegerField(verbose_name='Незанятый хедкаунт', default=0)),
                ('reserve_new_headcount', models.IntegerField(verbose_name='Кредит', default=0)),
                ('occupied_replacement_cross_headcount', models.IntegerField(verbose_name='работающих с пересечением', default=0)),
                ('offer_replacement_cross_headcount', models.IntegerField(verbose_name='оффера с пересечением', default=0)),
                ('vacancy_plan_replacement_cross_headcount', models.IntegerField(verbose_name='открытых вакансий с пересечением', default=0)),
                ('vacancy_open_replacement_cross_headcount', models.IntegerField(verbose_name='плановых вакансий с пересечением', default=0)),
                ('vacancy_plan_replacement_headcount', models.IntegerField(default=0)),
                ('occupied_replacement_headcount', models.IntegerField(default=0)),
                ('offer_replacement_headcount', models.IntegerField(default=0)),
                ('vacancy_open_replacement_headcount', models.IntegerField(default=0)),
                ('occupied_new_cross_headcount', models.IntegerField(default=0)),
                ('offer_new_cross_headcount', models.IntegerField(default=0)),
                ('vacancy_plan_new_cross_headcount', models.IntegerField(default=0)),
                ('vacancy_open_new_cross_headcount', models.IntegerField(default=0)),
                ('reserve_new_cross_headcount', models.IntegerField(default=0)),
            ],
            options={
                'permissions': (('can_view_headcounts', 'Can view headcounts'),),
            },
        ),
        migrations.CreateModel(
            name='DepartmentInterfaceSection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(verbose_name='models.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='models.modified_at-label', auto_now=True)),
                ('name', models.CharField(max_length=255, default='')),
                ('name_en', models.CharField(max_length=255, default='')),
                ('description', models.CharField(max_length=4096)),
                ('order', models.IntegerField(default=0)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DepartmentRole',
            fields=[
                ('position', models.IntegerField(default=0)),
                ('id', models.CharField(primary_key=True, max_length=32, serialize=False)),
                ('slug', models.CharField(max_length=32, db_index=True, default='')),
                ('name', models.CharField(max_length=64, default='')),
                ('name_en', models.CharField(max_length=64, default='')),
                ('show_in_structure', models.BooleanField(default=False)),
                ('manage_by_idm', models.BooleanField(default=True)),
                ('is_active', models.BooleanField(default=True)),
                ('holders', models.ManyToManyField(related_name='department_roles', to='django_intranet_stuff.Staff', through='django_intranet_stuff.DepartmentStaff')),
                ('permissions', models.ManyToManyField(blank=True, related_name='department_roles', to='auth.Permission')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HeadcountPosition',
            fields=[
                ('id', models.CharField(primary_key=True, max_length=64, serialize=False)),
                ('code', models.IntegerField(db_index=True)),
                ('category_is_new', models.BooleanField(default=False)),
                ('status', models.CharField(max_length=32, choices=[('OCCUPIED', 'OCCUPIED'), ('OFFER', 'OFFER'), ('VACANCY_OPEN', 'VACANCY_OPEN'), ('VACANCY_PLAN', 'VACANCY_PLAN'), ('RESERVE', 'RESERVE'), ('MATERNITY', 'MATERNITY')])),
                ('name', models.CharField(max_length=128)),
                ('geo', models.CharField(max_length=16)),
                ('bonus_id', models.IntegerField()),
                ('reward_id', models.IntegerField()),
                ('review_id', models.IntegerField()),
                ('headcount', models.IntegerField(verbose_name='headcount позиции')),
                ('is_crossing', models.BooleanField(verbose_name='пересечение', default=False)),
                ('current_login', models.CharField(max_length=25, null=True)),
                ('previous_login', models.CharField(max_length=25, null=True)),
                ('previous_login2', models.CharField(max_length=25, null=True)),
                ('main_assignment', models.BooleanField(default=True)),
                ('in_total_hc', models.BooleanField(default=False)),
                ('index', models.IntegerField(null=True, default=1)),
                ('prev_index', models.IntegerField(null=True)),
                ('next_index', models.IntegerField(null=True)),
                ('replacement_type', models.CharField(max_length=32, default='WO_REPLACEMENT', choices=[('HAS_REPLACEMENT', 'HAS_REPLACEMENT'), ('HC_IS_BUSY', 'HC_IS_BUSY'), ('HAS_REPLACEMENT_AND_HC_IS_BUSY', 'HAS_REPLACEMENT_AND_HC_IS_BUSY'), ('WO_REPLACEMENT', 'WO_REPLACEMENT')])),
                ('current_person', models.ForeignKey(null=True, related_name='+', to='django_intranet_stuff.Staff')),
                ('department', models.ForeignKey(related_name='positions', to='django_intranet_stuff.Department')),
            ],
            options={
                'permissions': (('can_export_ceilings', 'Can export ceilings data'),),
            },
        ),
        migrations.CreateModel(
            name='HrDeadline',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('month', models.DateField(validators=[staff.departments.models.hr_deadline.validate_is_first_day])),
                ('date', models.DateField()),
                ('type', models.CharField(max_length=32, choices=[('salary_change', 'salary_change'), ('structure_change', 'structure_change'), ('future_change', 'future_change'), ('table_transfer', 'table_transfer'), ('deal_date', 'deal_date')])),
            ],
        ),
        migrations.CreateModel(
            name='HRProduct',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('product_name', models.CharField(max_length=128, default='')),
                ('end_date', models.DateField(null=True, default=None)),
                ('service_id', models.IntegerField(unique=True, null=True)),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('value_stream', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Department')),
            ],
        ),
        migrations.CreateModel(
            name='ProposalMetadata',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('proposal_id', models.CharField(verbose_name='_id заявки', max_length=25, unique=True, db_index=True)),
                ('created_at', models.DateTimeField(null=True, auto_now_add=True)),
                ('applied_at', models.CharField(verbose_name='Время применения', max_length=26, blank=True, null=True, db_index=True, default=None)),
                ('pushed_to_oebs', models.CharField(verbose_name='Время пуша в ОЕБС', max_length=26, blank=True, null=True, default=None)),
                ('deleted_at', models.DateTimeField(null=True)),
                ('applied_by', models.ForeignKey(verbose_name='Кто применил', blank=True, null=True, default=None, to='django_intranet_stuff.Staff')),
                ('author', models.ForeignKey(verbose_name='Автор заявки', blank=True, null=True, default=None, related_name='+', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='RelevanceDate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('relevance_date', models.DateField()),
                ('last_sync_time', models.DateTimeField(null=True, auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Vacancy',
            fields=[
                ('id', models.IntegerField(verbose_name='ID вакансии', primary_key=True, serialize=False)),
                ('name', models.CharField(verbose_name='Наименование вакансии', max_length=255, default='')),
                ('ticket', models.CharField(verbose_name='JOB тикет', max_length=32, null=True)),
                ('salary_ticket', models.CharField(verbose_name='SALARY тикет', max_length=32, null=True)),
                ('offer_id', models.IntegerField(verbose_name='ID оффера', null=True)),
                ('headcount_position_code', models.IntegerField(null=True, db_index=True)),
                ('candidate_id', models.IntegerField(verbose_name='ID кандидата', null=True)),
                ('candidate_first_name', models.CharField(verbose_name='имя кандидата', max_length=255, blank=True)),
                ('candidate_last_name', models.CharField(verbose_name='фамилия кандидата', max_length=255, blank=True)),
                ('candidate_login', models.CharField(verbose_name='логин кандидата', max_length=64, blank=True)),
                ('is_active', models.BooleanField(verbose_name='вакансия в активном статусе', default=False)),
                ('status', models.CharField(verbose_name='статус вакансии', max_length=64, choices=[('closed', 'closed'), ('draft', 'draft'), ('on_approval', 'on_approval'), ('offer_accepted', 'offer_accepted'), ('suspended', 'suspended'), ('in_progress', 'in_progress'), ('offer_processing', 'offer_processing')])),
                ('application_id', models.IntegerField(verbose_name='application ID', null=True)),
                ('is_published', models.BooleanField(verbose_name='Внутреннее объявление опубликовано')),
                ('is_hidden', models.BooleanField(verbose_name='Вакансия скрыта', default=False)),
                ('budget_position', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='budget_position.BudgetPosition')),
                ('department', models.ForeignKey(null=True, related_name='femida_vacancies', to='django_intranet_stuff.Department')),
                ('occupation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='person.Occupation')),
                ('preprofile', models.ForeignKey(null=True, related_name='vacancy', to='preprofile.Preprofile')),
            ],
        ),
        migrations.CreateModel(
            name='VacancyMember',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('person', models.ForeignKey(to='django_intranet_stuff.Staff')),
                ('vacancy', models.ForeignKey(to='departments.Vacancy')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='hrdeadline',
            unique_together=set([('month', 'type')]),
        ),
        migrations.AddField(
            model_name='headcountposition',
            name='hr_product',
            field=models.ForeignKey(null=True, to='departments.HRProduct'),
        ),
        migrations.AddField(
            model_name='headcountposition',
            name='previous_person',
            field=models.ForeignKey(null=True, related_name='+', to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='headcountposition',
            name='valuestream',
            field=models.ForeignKey(null=True, related_name='valuestreamed_headcount_positions', to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='departmentchain',
            name='department',
            field=models.OneToOneField(to='django_intranet_stuff.Department'),
        ),
        migrations.AlterIndexTogether(
            name='headcountposition',
            index_together=set([('valuestream', 'status')]),
        ),
    ]
