# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('departments', '0009_move_can_view_headcounts'),
    ]

    operations = [
        migrations.RunSQL(
            sql='''INSERT INTO departments_departmentrole_permissions(permission_id, departmentrole_id)
SELECT p.id AS permission_id, r.id AS departmentrole_id
    FROM auth_permission p
    CROSS JOIN departments_departmentrole r
    WHERE p.codename = 'can_view_headcounts' AND r.id IN ('HEADCOUNT_VIEWER', 'VALUESTREAM_HEAD', 'VALUESTREAM_MANAGER', 'VALUESTREAM_HRBP')
ON CONFLICT DO NOTHING;''',
        ),
        migrations.RunSQL(
            sql='''
INSERT INTO intranet_group_permissions(permission_id, group_id)
SELECT p.id AS permission_id, g.id AS group_id
    FROM auth_permission p
    CROSS JOIN intranet_group g
    WHERE p.codename = 'can_view_headcounts' AND g.url = 'headcount_viewers'
ON CONFLICT DO NOTHING;''',
        ),
    ]
