from django.db import models
from staff.lib.models.base import IntranetModel


class Bonus(IntranetModel):
    scheme_id = models.IntegerField(primary_key=True)
    schemes_line_id = models.IntegerField(null=True)

    name = models.CharField(null=False, max_length=255)
    description = models.CharField(null=True, blank=True, max_length=255)

    start_date = models.DateField(null=False)
    end_date = models.DateField(null=True)

    scheme_data = models.TextField(null=True, blank=True, max_length=10240)
    non_review_bonus = models.FloatField(null=True)

    def __str__(self):
        return f'Id:{self.scheme_id} ({self.name})'

    class Meta(IntranetModel.Meta):
        app_label = 'departments'
