from django.db import models

from staff.person.models import Staff


class ProposalMetadata(models.Model):
    proposal_id = models.CharField(max_length=25, verbose_name='_id заявки', unique=True, db_index=True)

    author = models.ForeignKey(
        Staff, default=None, null=True, blank=True, verbose_name='Автор заявки', related_name='+',
    )

    created_at = models.DateTimeField(null=True, auto_now_add=True)

    applied_by = models.ForeignKey(Staff, default=None, null=True, blank=True, verbose_name='Кто применил')

    applied_at = models.CharField(
        max_length=26, default=None, null=True, blank=True, verbose_name='Время применения', db_index=True,
    )

    pushed_to_oebs = models.CharField(
        max_length=26, default=None, null=True, blank=True, verbose_name='Время пуша в ОЕБС',
    )

    deleted_at = models.DateTimeField(null=True)

    def __str__(self):
        return self.proposal_id
