from django.db import models

from staff.lib.models.base import IntranetModel

from staff.departments.models.department import Department, InstanceClass


class Geography(IntranetModel):
    class Meta(IntranetModel.Meta):
        app_label = 'departments'

    name = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, default='')
    oebs_code = models.CharField(unique=True, null=True, max_length=32)
    oebs_description = models.CharField(max_length=255, null=True, blank=True)
    st_translation_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name='id от объекта translation из startrek',
    )
    department_instance = models.OneToOneField(
        Department,
        null=False,
        related_name='geography_instance',
        limit_choices_to={'instance_class': InstanceClass.GEOGRAPHY.value},
    )

    def __str__(self):
        return f'{self.name} ({self.oebs_code})'
