from django.db import models

from staff.departments.models.department import Department
from staff.departments.models.hr_product import HRProduct
from staff.oebs.constants import PERSON_POSITION_STATUS, REPLACEMENT_TYPE


class HeadcountPosition(models.Model):
    class Meta:
        permissions = (
            ('can_export_ceilings', 'Can export ceilings data'),
            ('can_view_headcounts', 'Can view headcounts'),
        )
        index_together = (
            ('valuestream', 'status'),
        )

    id = models.CharField(
        primary_key=True,
        null=False,
        blank=False,
        max_length=64,
    )

    code = models.IntegerField(
        null=False,
        blank=False,
        db_index=True,
    )

    department = models.ForeignKey(
        'django_intranet_stuff.Department',
        related_name='positions',
    )

    category_is_new = models.BooleanField(
        null=False,
        blank=False,
        default=False,
    )

    status = models.CharField(
        choices=PERSON_POSITION_STATUS,
        null=False,
        blank=False,
        max_length=32,
    )

    name = models.CharField(
        null=False,
        blank=False,
        max_length=128,
    )

    hr_product = models.ForeignKey(
        HRProduct,
        null=True,
    )

    valuestream = models.ForeignKey(
        Department,
        related_name='valuestreamed_headcount_positions',
        null=True,
    )

    geo = models.CharField(
        null=False,
        blank=False,
        max_length=16,
    )

    bonus_id = models.IntegerField(
        null=False,
        blank=False,
    )

    reward_id = models.IntegerField(
        null=False,
        blank=False,
    )

    review_id = models.IntegerField(
        null=False,
        blank=False,
    )

    headcount = models.IntegerField(
        null=False,
        blank=False,
        verbose_name='headcount позиции',
    )

    is_crossing = models.BooleanField(
        null=False,
        blank=False,
        verbose_name='пересечение',
        default=False,
    )

    current_login = models.CharField(
        max_length=25,
        null=True,
        blank=False,
    )

    current_person = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='+',
        null=True,
    )

    previous_login = models.CharField(
        max_length=25,
        null=True,
        blank=False,
    )

    previous_person = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='+',
        null=True,
    )

    previous_login2 = models.CharField(
        max_length=25,
        null=True,
        blank=False,
    )

    main_assignment = models.BooleanField(
        null=False,
        blank=False,
        default=True,
    )

    in_total_hc = models.BooleanField(
        null=False,
        blank=False,
        default=False,
    )
    index = models.IntegerField(null=True, default=1)
    prev_index = models.IntegerField(null=True)
    next_index = models.IntegerField(null=True)
    replacement_type = models.CharField(
        choices=REPLACEMENT_TYPE,
        null=False,
        blank=False,
        max_length=32,
        default=REPLACEMENT_TYPE.WO_REPLACEMENT,
    )

    def __str__(self):
        return 'Position {} with code {} in {}'.format(
            self.name,
            self.code,
            self.department.url,
        )


class RelevanceDate(models.Model):
    model_name = models.CharField(max_length=32, unique=True, null=True)
    relevance_date = models.DateField(null=False)
    updated_entities = models.IntegerField(null=True)
    failed_entities = models.IntegerField(null=True)
    skipped_entities = models.IntegerField(null=True)

    last_sync_time = models.DateTimeField(auto_now=True, null=True)

    def __str__(self):
        return f'{self.model_name}: {self.relevance_date} ({self.failed_entities} errors)'
