import datetime

from django.core.exceptions import ValidationError
from django.db import models

from staff.lib.utils.ordered_choices import OrderedChoices


DEADLINE_TYPE = OrderedChoices(
    ('SALARY_CHANGE', 'salary_change'),
    ('STRUCTURE_CHANGE', 'structure_change'),
    ('FUTURE_CHANGE', 'future_change'),
    ('TABLE_TRANSFER', 'table_transfer'),
    ('DEAL_DATE', 'deal_date'),
)


def validate_is_first_day(d: datetime.date) -> None:
    if d.day != 1:
        raise ValidationError('Month accepts only first day of the month')


class HrDeadline(models.Model):
    month = models.DateField(  # month.month can be different from date.month
        null=False,
        blank=False,
        validators=[validate_is_first_day]
    )
    date = models.DateField(
        null=False,
        blank=False,
    )
    type = models.CharField(
        null=False,
        blank=False,
        max_length=32,
        choices=DEADLINE_TYPE.choices(),
    )

    class Meta:
        unique_together = ('month', 'type')
