from django.db import models
from staff.lib.models.base import IntranetModel

from staff.departments.models import Department


class HRProduct(IntranetModel):
    product_name = models.CharField(max_length=128, null=False, default='')
    end_date = models.DateField(null=True, default=None)
    value_stream = models.ForeignKey(Department, null=True, on_delete=models.SET_NULL)
    service_id = models.IntegerField(unique=True, null=True)
    st_translation_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name='id от объекта translation из startrek',
    )

    class Meta:
        app_label = 'departments'
