from django.db import models

from staff.femida.constants import VACANCY_STATUS
from staff.preprofile.models import Preprofile

from staff.departments.models import Department


class Vacancy(models.Model):
    id = models.IntegerField(
        primary_key=True,
        null=False,
        blank=False,
        verbose_name='ID вакансии',
    )

    name = models.CharField(
        blank=False,
        max_length=255,
        default='',
        verbose_name='Наименование вакансии',
    )

    ticket = models.CharField(
        null=True,
        blank=False,
        max_length=32,
        verbose_name='JOB тикет',
    )

    salary_ticket = models.CharField(
        null=True,
        blank=False,
        max_length=32,
        verbose_name='SALARY тикет',
    )

    offer_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='ID оффера',
    )

    headcount_position_code = models.IntegerField(
        null=True,
        blank=False,
        db_index=True,
    )
    budget_position = models.ForeignKey(
        'budget_position.BudgetPosition',
        on_delete=models.PROTECT,
        null=True,
    )

    preprofile = models.ForeignKey(
        Preprofile,
        related_name='vacancy',
        null=True,
    )

    candidate_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='ID кандидата',
    )

    candidate_first_name = models.CharField(
        max_length=255,
        blank=True,
        verbose_name='имя кандидата',
    )

    candidate_last_name = models.CharField(
        max_length=255,
        blank=True,
        verbose_name='фамилия кандидата',
    )

    candidate_login = models.CharField(
        max_length=64,
        blank=True,
        verbose_name='логин кандидата',
    )

    is_active = models.BooleanField(
        default=False,
        verbose_name='вакансия в активном статусе',
    )

    status = models.CharField(
        max_length=64,
        choices=VACANCY_STATUS.choices(),
        blank=False,
        null=False,
        verbose_name='статус вакансии',
    )

    application_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='application ID',
    )

    department = models.ForeignKey(
        Department,
        related_name='femida_vacancies',
        null=True,  # TODO: разобраться откуда в тестинге здесь пустые департаменты
    )

    is_published = models.BooleanField(
        blank=False,
        null=False,
        verbose_name='Внутреннее объявление опубликовано',
    )

    is_hidden = models.BooleanField(
        blank=False,
        default=False,  # TODO: Remove after sync
        null=False,
        verbose_name='Вакансия скрыта',
    )

    occupation = models.ForeignKey(
        'person.Occupation',
        on_delete=models.PROTECT,
        null=True,
    )

    def __str__(self):
        return self.name
