from staff.django_intranet_notifications import Notification


class DepartmentNotification(Notification):
    def get_subj_id(self):
        if 'department' in self.context:
            return 'department_%d' % self.context['department'].pk
        else:
            return 'department'


class DepartmentChiefUpdateNotification(DepartmentNotification):
    template = 'departments/notifications/departments_chief_updated.html'


class DepartmentDeputiesUpdateNotification(DepartmentNotification):
    template = 'departments/notifications/departments_deputies_updated.html'


class NEW_DepartmentDeputiesUpdateNotification(DepartmentNotification):
    template = 'departments/notifications/_departments_deputies_updated.html'


class DepartmentCreated(DepartmentNotification):
    template = 'departments/notifications/department_created.html'


class DepartmentUrlChanged(DepartmentNotification):
    template = 'departments/notifications/department_url_changed.html'


class DepartmentDeleted(DepartmentNotification):
    template = 'departments/notifications/department_deleted.html'
