from django import template

register = template.Library()


@register.inclusion_tag('startrek/department/include/text_value.html')
def name_section(data):
    data['field_name'] = 'Название'
    data['field_name_en'] = 'Name'
    return data


@register.inclusion_tag('startrek/department/include/text_value.html')
def name_en_section(data):
    data['field_name'] = 'Название (англ.)'
    data['field_name_en'] = 'Name (eng.)'
    return data


@register.inclusion_tag('startrek/department/include/department_value.html')
def parent_section(parent_data, fake_parent_data=None):
    parent_data['field_name'] = 'Родительское подразделение'
    parent_data['field_name_en'] = 'Parent department'
    if fake_parent_data and 'new' in fake_parent_data:
        parent_data['fake_new'] = fake_parent_data['new']
    if 'new' in parent_data and 'new_dep_name' in parent_data:
        parent_data['new'].name = parent_data['new_dep_name']
    if fake_parent_data and fake_parent_data.get('value'):
        parent_data['value'] = fake_parent_data.get('value')
    return parent_data


@register.inclusion_tag('startrek/department/include/person_value.html')
def chief_section(data):
    data['field_name'] = 'Руководитель'
    data['field_name_en'] = 'Chief'
    return data


@register.inclusion_tag('startrek/department/include/person_value.html')
def deputies_section(data):
    data['field_name'] = 'Заместители'
    data['field_name_en'] = 'Deputies'
    return data


@register.inclusion_tag('startrek/department/include/text_value.html')
def code_section(data):
    data['field_name'] = 'Код'
    data['field_name_en'] = 'Code'
    return data


@register.inclusion_tag('startrek/department/include/text_value.html')
def position_section(data):
    data['field_name'] = 'Порядок в дереве'
    data['field_name_en'] = 'Position'
    return data


@register.inclusion_tag('startrek/department/include/text_value.html')
def category_section(data):
    data['field_name'] = 'Категория подразделения'
    data['field_name_en'] = 'Category'
    return data


@register.inclusion_tag('startrek/department/include/text_value.html')
def kind_section(data):
    data['new'] = data['new'].name
    data['old'] = data['old'].name
    data['field_name'] = 'Тип подразделения'
    data['field_name_en'] = 'Department type'
    return data
