from typing import Sequence

from staff.departments.tree_lib import AbstractEntityInfo


class VacanciesEntityInfo(AbstractEntityInfo):

    def fill_counters(self, all_ids, departments):
        pass

    def fill_info(self, all_ids, departments, info_map):
        for dep in departments:
            info = dep.setdefault('info', {})

            if info_map is not None and dep['id'] in info_map:
                info['vacancies'] = info_map[dep['id']]

        return departments

    def fill_dep_attrs(self, all_ids: Sequence, departments: Sequence) -> Sequence:
        return departments

    def filter_result(self, departments):
        if not self.filter_context.filter_id:
            return departments

        return [d for d in departments if d['persons_qty']]

    def fill_list(self, entities):
        return entities

    def departments_query(self):
        return self.filter_context.departments_qs().order_by('tree_id', 'level', 'lft')

    def short_entities_query(self):
        return self.filter_context.vacancies_qs()

    def full_entities_query(self):
        return self.filter_context.vacancies_qs()

    def total_entities_count_query(self):
        return self.total_entities_aggregate_query(['id'])

    def total_entities_aggregate_query(self, fields):
        return self.filter_context.vacancies_qs(fields)
